﻿#pragma once
#include <SDXFrameWork.h>
#include <Framework/IScene.h>
#include <Framework/Module.h>
#include <STG/Layer.h>
#include "Unit.h"
#include "Shot.h"

namespace SDX
{
using namespace SDX;
class Scene : public IScene
{
private:
	std::list<Layer*> layers;

	Layer backEfects;
	Layer midEfects;
	Layer frontEfects;

	Layer allys;
	Layer skyEnemys;
	Layer earthEnemys;
	Layer items;

	Layer allyShots;
	Layer enemyShots;

	Layer blocks;

	std::vector<IModule*> events;

	static Scene* sceneNow;

	void ExeEvent()
	{
		for (auto it : events)
		{
			it->Update();
		}
	}

	void Remove()
	{	
		for(auto it : layers )
		{
			it->ExeRemove( &area );
		}
	}

	void Clear()
	{
		timer = 0;
		for( auto it : layers )
		{
			it->Clear();
		}
	}

	void Hit()
	{
		//ブロック
		blocks.Hit( allys );
		blocks.Hit( skyEnemys );
		blocks.Hit( allyShots );
		blocks.Hit( enemyShots );

		//敵,敵弾,自機,自機弾
		allys.Hit( skyEnemys );
		allys.Hit( enemyShots );
		skyEnemys.Hit( allyShots );
		earthEnemys.Hit( allyShots );

		//アイテム
		if( !GetPlayer()->GetRemoveFlag() ) items.Hit( GetPlayer() );
	}

public:
	int timer = 0;
	bool isEnd = false;

	std::unique_ptr<Camera> camera;

	double scrSpeedX = 0;
	double scrSpeedY = 0;

	Rect area = Rect(300 , 300 , 640 , 700);
	Rect moveArea = Rect(300 , 300 , 600 , 600);

	std::shared_ptr<Object> player;

	Scene():
		camera( new Camera( 400 , 300 , 1) )
	{
		SetNow();
		layers.push_back(&backEfects);
		layers.push_back(&allys);
		layers.push_back(&earthEnemys);
		layers.push_back(&blocks);
		layers.push_back(&midEfects);
		layers.push_back(&skyEnemys);
		layers.push_back(&allyShots);
		layers.push_back(&enemyShots);
		layers.push_back(&items);
		layers.push_back(&frontEfects);
	}

	virtual ~Scene(){}

	void SetNow()
	{
		sceneNow = this;
		camera->SetActive();
	}

	static Scene* Now()
	{
		return sceneNow;
	}

	void Update()
	{
		SetNow();
		camera->SetActive();
		timer++;

		ExeEvent();

		for( auto it : layers )
		{
			it->Update();
		}

		camera->Update();
		Hit();
		Remove();
	}

	void Draw()
	{
		SetNow();
		backEfects.Draw();	
		earthEnemys.Draw();

		Screen::SetBright({ 0, 0, 0 });
		Screen::SetBlendMode( BlendMode::Alpha , 128 );
		allys.DrawShadow( 50 , 50 );
		skyEnemys.DrawShadow( 50 , 50 );
		Screen::SetBlendMode( BlendMode::NoBlend , 0 );		
		Screen::SetBright({ 255, 255, 255 });

		midEfects.Draw();
		allyShots.Draw();
		blocks.Draw();
		allys.Draw();
		skyEnemys.Draw();
		enemyShots.Draw();
		items.Draw();
		frontEfects.Draw();
	}

	void ExeInit()
	{
		SetNow();
		Init();
		Clear();
	}

	void ExeFinal()
	{
		SetNow();
		Final();
		Clear();
	}

	virtual void Init()
	{
	}

	virtual void Final()
	{
	}

	static void SetPlayer( Unit* player)
	{
		Now()->Add(player);
		Now()->player = Now()->allys.objects[0];
	}

	static Object* GetPlayer()
	{
		return Now()->player.get();
	}

	static void Add(Unit *unit, int suspendTime = 0)
	{
		switch( unit->GetBelong())
		{
			case Belong::Ally:Now()->allys.Add( unit , suspendTime );break;
			case Belong::EnemyF:Now()->skyEnemys.Add(unit, suspendTime); break;
			case Belong::EnemyG:Now()->earthEnemys.Add(unit, suspendTime); break;
			case Belong::Block:Now()->blocks.Add(unit, suspendTime); break;
			case Belong::Item:Now()->items.Add(unit, suspendTime); break;
		}
	}

	static void Add(Shot *shot, int suspendTime = 0)
	{
		if (shot->GetBelong() == Belong::Ally)
		{
			Now()->allyShots.Add(shot, suspendTime);
		}else{
			Now()->enemyShots.Add(shot, suspendTime);
		}
	}

	static void Add(Object *obj, int suspendTime = 0)
	{	
		Now()->midEfects.Add(obj, suspendTime);
	}

	static void AddFront(Object *object, int suspendTime = 0)
	{	
		Now()->frontEfects.Add(object, suspendTime);
	}

	static void AddBack(Object *object, int suspendTime = 0)
	{
		Now()->backEfects.Add(object, suspendTime);
	}

	static void AddEvent(IModule *module)
	{
		Now()->events.emplace_back(module);
	}

	static void AddEvent(std::function<void()> fmodule)
	{
		Now()->events.emplace_back(new FuncModule(fmodule));
	}

	static Object* GetNearEnemy(Object* object)
	{
		if( Now()->skyEnemys.GetCount() == 0 )
		{
			return Now()->earthEnemys.GetNearest(object);
		}
		return Now()->skyEnemys.GetNearest(object);
	}

	bool IsEnd()
	{
		return isEnd;
	}
};
}